# 通知設計書 27-Long Path有効化失敗通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「Long Path有効化失敗通知」の設計仕様を定義する。この通知は、WindowsのLong Path（長いパス）サポートをレジストリで有効化しようとした際に失敗した場合にユーザーにエラーを表示するものである。

### 本通知の処理概要

この通知は、StaxRipでLong Pathサポートを有効化するためのレジストリ操作が失敗した場合に表示されるエラー機能を提供する。

**業務上の目的・背景**：従来のWindowsでは、ファイルパスの長さが260文字（MAX_PATH）に制限されていた。深いフォルダ構造や長いファイル名を使用する場合、この制限によりファイルアクセスに問題が発生することがある。Windows 10以降では、レジストリ設定により260文字を超えるパスのサポートを有効化できる。StaxRipはユーザーがこの設定を有効化できる機能を提供しているが、レジストリ操作には管理者権限が必要であり、操作が失敗する可能性がある。失敗した場合にユーザーに状況を通知する必要がある。

**通知の送信タイミング**：Long Pathサポート有効化処理において、reg.exeを使用したレジストリ操作（HKLM\SYSTEM\CurrentControlSet\Control\FileSystemのLongPathsEnabledキーの設定）が失敗した場合（終了コード0以外、または例外発生時）に発生する。

**通知の受信者**：StaxRipアプリケーションを使用しているユーザー（操作者）がダイアログボックスを通じてエラー通知を受け取る。

**通知内容の概要**：「Something went wrong, the Long Path Support was not enabled!」というメッセージがエラーダイアログとして表示される。例外発生時は追加でエラーメッセージ（ex.Message）も表示される。

**期待されるアクション**：ユーザーは以下の対応を検討する必要がある：(1) 管理者権限でStaxRipを実行して再試行する、(2) 手動でレジストリを編集する、(3) Long Path機能を使用せず、短いパスを使用する、(4) 「今後チェックしない」オプションを選択してこの機能を無効化する。

## 通知種別

アプリ内通知（TaskDialogエラーダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

現在StaxRipを操作しているユーザーに対してモーダルダイアログとして表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Error（エラーアイコン） |
| タイトル | Something went wrong, the Long Path Support was not enabled! |
| 本文 | （例外時）例外メッセージ（ex.Message） |
| ボタン | OK、Copy |

### 本文テンプレート

```
Something went wrong, the Long Path Support was not enabled!

{例外発生時: 例外メッセージ}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| ex.Message | 例外メッセージ | Exception.Message | No（例外時のみ） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Long Path有効化実行時 | regProcess.ExitCode <> 0 | レジストリ操作の終了コードがエラー |
| 画面操作 | Long Path有効化実行時 | Exception発生 | reg.exeプロセス実行中に例外発生 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| regProcess.ExitCode = 0の場合 | レジストリ操作が成功した場合は通知しない |
| ユーザーがIgnoreを選択した場合 | s.CheckForLongPathSupport = Falseになり次回から確認しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Long Path有効化ダイアログ] --> B{ユーザー選択}
    B -->|Yes| C[Try: Process.Start reg.exe]
    B -->|No| D[終了]
    B -->|Ignore| E[s.CheckForLongPathSupport = False]
    C --> F[WaitForExit]
    F --> G{ExitCode = 0?}
    G -->|No| H[MsgError呼び出し - 終了コードエラー]
    G -->|Yes| I[成功]
    C -->|Exception| J[MsgError呼び出し - 例外メッセージ付き]
    H --> K[エラーダイアログ表示]
    J --> K
    E --> D
    I --> D
    K --> D
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | Windowsレジストリを参照・更新 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Windows Registry | UPDATE | HKLM\SYSTEM\CurrentControlSet\Control\FileSystem\LongPathsEnabled = 1 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 終了コードエラー | ExitCode <> 0 | MsgErrorで通知 |
| 例外発生 | Process.Start等で例外 | MsgErrorで例外メッセージとともに通知 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

- 管理者権限でのレジストリ操作が必要
- UACプロンプトが表示される（Verb = "runas"）
- 例外メッセージにシステム情報が含まれる可能性があるが、ローカル表示のみ

## 備考

- Long PathサポートはWindows 10バージョン1607以降で利用可能
- レジストリキー：HKLM\SYSTEM\CurrentControlSet\Control\FileSystem
- 値名：LongPathsEnabled
- 値：1（有効）/ 0（無効）
- 設定変更は再起動後に有効になる場合がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アプリケーション設定とレジストリ操作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ApplicationSettings.vb | `Source/General/` | CheckForLongPathSupportプロパティの定義を確認 |

**読解のコツ**: s.CheckForLongPathSupportはユーザーがIgnoreを選択した場合にFalseになり、次回以降のチェックを抑止する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | Long Path処理部分（行1770-1789付近）がエントリーポイント |

**主要処理フロー**:
1. **行1770-1774**: ProcessStartInfo設定（reg.exe、引数、runas権限）
2. **行1776-1777**: Process.Start、WaitForExit
3. **行1779-1780**: If regProcess.ExitCode <> 0 Then MsgError - 終了コードチェック
4. **行1783-1784**: Catch ex As Exception MsgError(...ex.Message) - 例外ハンドリング
5. **行1786-1787**: ElseIf td.SelectedValue = DialogResult.Ignore Then - Ignore選択時の処理

#### Step 3: レジストリ操作詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | ProcessStartInfoの引数構築を確認 |

**主要処理フロー**:
- **Arguments**: `reg add HKLM\SYSTEM\CurrentControlSet\Control\FileSystem /v LongPathsEnabled /t REG_DWORD /d 1 /f`
- **Verb**: "runas" - 管理者権限で実行

### プログラム呼び出し階層図

```
MainForm / 初期化処理
    │
    └─ Long Pathチェック処理
           │
           ├─ TaskDialog表示（Yes/No/Ignore）
           │      │
           │      ├─ (Yes) reg.exe実行
           │      │      │
           │      │      ├─ (ExitCode <> 0) MsgError()
           │      │      │      │
           │      │      │      └─ TaskDialog.Show()
           │      │      │
           │      │      └─ (Exception) MsgError(ex.Message)
           │      │             │
           │      │             └─ TaskDialog.Show()
           │      │
           │      ├─ (No) 終了
           │      │
           │      └─ (Ignore) s.CheckForLongPathSupport = False
           │
           └─ 終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

TaskDialog選択 ───▶ Yes/No/Ignore分岐

(Yes時)
ProcessStartInfo ───▶ Process.Start(reg.exe) ───▶ WaitForExit
     │
     ▼
ExitCode       ───▶ <> 0 判定             ───▶ Boolean
     │
     │ (True時 または Exception時)
     ▼
MsgError()     ───▶ TaskDialog表示        ───▶ ユーザーへのエラー通知
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | Long Path処理、通知発生元 |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数の実装 |
| ApplicationSettings.vb | `Source/General/` | ソース | CheckForLongPathSupport設定 |
| Misc.vb | `Source/General/Misc.vb` | ソース | グローバル変数sの定義 |
